//+------------------------------------------------------------------+
//|                                                    SAR_COLOR.mq4 |
//|                                                          Kalenzo |
//|                                       http://www.foreksik.prv.pl |
//+------------------------------------------------------------------+
#property copyright "Kalenzo"
#property link      "http://www.foreksik.prv.pl"

#property indicator_color1 Red
#property indicator_color2 Blue
#property indicator_chart_window
#property indicator_buffers 2
#property indicator_width1 0
#property indicator_width2 0

double sarUp[],sarDn[];//buffers
extern bool AlertsEnabled=false;
extern double Step = 0.06;//was .01
extern double Maximum = 0.2;
extern int Precision = 7;
double alertBar;
extern int TimeFrame=0;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_ARROW,STYLE_DOT);
   SetIndexStyle(1,DRAW_ARROW,STYLE_DOT);
   SetIndexBuffer(0,sarUp);
   SetIndexBuffer(1,sarDn);
   SetIndexArrow(0,159);
   SetIndexArrow(1,159);
   
   IndicatorShortName("SAR COLORED");
   SetIndexLabel(0,"SAR Up Channel");
   SetIndexLabel(1,"SAR Down Channel");
   
   SetIndexDrawBegin(0,2);
   SetIndexDrawBegin(1,2);
//----
switch(TimeFrame)
   {
      case 1 : string TimeFrameStr="Period_M1"; break;
      case 5 : TimeFrameStr="Period_M5"; break;
      case 15 : TimeFrameStr="Period_M15"; break;
      case 30 : TimeFrameStr="Period_M30"; break;
      case 60 : TimeFrameStr="Period_H1"; break;
      case 240 : TimeFrameStr="Period_H4"; break;
      case 1440 : TimeFrameStr="Period_D1"; break;
      case 10080 : TimeFrameStr="Period_W1"; break;
      case 43200 : TimeFrameStr="Period_MN1"; break;
      default : TimeFrameStr="Current Timeframe";
   }
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   datetime TimeArray[];
   int    i,limit,y=0,counted_bars=IndicatorCounted();
 
// Plot defined time frame on to current time frame
   ArrayCopySeries(TimeArray,MODE_TIME,Symbol(),TimeFrame); 
   
   limit=Bars-counted_bars;
   for(i=0,y=0;i<limit;i++)
   {
   if (Time[i]<TimeArray[y]) y++;
   
      double sar = NormalizeDouble(iSAR(Symbol(),TimeFrame,Step,Maximum,y),Precision);
          if(sar >= iHigh(Symbol(),0,i))
      {
       if(AlertsEnabled==true && sarUp[i] == 0 && Bars>alertBar)
        {
        Alert("Parabolic SAR Going Down on ",Symbol(),"-",Period());
        alertBar = Bars;
       }
         sarUp[i] = sar;  
         sarDn[i] = 0;
      }
    else
      {
       if(AlertsEnabled==true && sarDn[i] == 0 && Bars>alertBar)
        {
        Alert("Parabolic SAR Channel Going Up on ",Symbol(),"-",Period());
        alertBar = Bars;
        }
         sarUp[i] = 0;
         sarDn[i] = sar;
         WindowRedraw();

       }
   }
 //----
   return(0);
  }
//+------------------------------------------------------------------+